//*******************************************************************************************************************************************************
//
//  Sample Program for Real-Time Kernel
//
//  Function:
//  unsigned char OSTaskCreate (void (*task)(void *pd), void *pdata, unsigned char *pstk, unsigned long stk_size, unsigned char piro) : Create a task.
//
//  void OSTimeDly (unsigned long ticks) : Allow a task to delay itself for a number of clock ticks.
//                                         Ticks is the delay time in units of 5 ms.
//
//  SYNTECH INFORMATION CO., LTD.
//
//*******************************************************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"
#include "..\lib\ucos.h"


#define  STK_SIZE  1000             // Size of each task's stacks (# of bytes)


int   ibeep[5] = {16, 5, 0, 0};

unsigned char  Stack[STK_SIZE];     // stack for Task_Reader
unsigned char  sDefaultBCR [25] = { 0x9b, 0xc9, 0x00, 0x00, 0x00, 0x21, 0x54,
                                    0x80, 0x00, 0x9d, 0x3d, 0x50, 0xc0, 0x01,
                                    0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0x66,
                                    0x03, 0x03 };

void  TaskReader(void);

//-------------------------------------------------------------------------//
void main (void)
    {
    char  sTime[15], sbuf[15];

    clr_scr ();
    gotoxy (2, 0);
    puts ("REAL-TIME KERNEL");

    gotoxy (2, 5);
    puts ("BARCODE:");

    OSTaskCreate ((void *)TaskReader, (void *)0, (void *)Stack, STK_SIZE, 14);

    while (1)
        {
        get_time (sTime);

        sbuf[ 0] = sTime[0];
        sbuf[ 1] = sTime[1];
        sbuf[ 2] = sTime[2];
        sbuf[ 3] = sTime[3];
        sbuf[ 4] = '/';
        sbuf[ 5] = sTime[4];
        sbuf[ 6] = sTime[5];
        sbuf[ 7] = '/';
        sbuf[ 8] = sTime[6];
        sbuf[ 9] = sTime[7];
        sbuf[10] = 0;

        gotoxy (2, 2);
        puts ("DATE:");
        printf ("%s", sbuf);

        sbuf[0] = sTime[8];
        sbuf[1] = sTime[9];
        sbuf[2] = ':';
        sbuf[3] = sTime[10];
        sbuf[4] = sTime[11];
        sbuf[5] = ':';
        sbuf[6] = sTime[12];
        sbuf[7] = sTime[13];
        sbuf[8] = 0;

        gotoxy (2, 3);
        puts ("TIME:");
        printf ("%s", sbuf);

        OSTimeDly (40);
        }
    }

//-------------------------------------------------------------------------//
void TaskReader(void)
    {
    int  i, flag, iCodeLen;

    OSTimeDly (10);

    for (i=0; i<24; i++)
        ScannerDesTbl[i] = sDefaultBCR[i];

    flag = 1;
    iCodeLen = 0;
    while (1)
        {
        if (flag)
            {
            InitScanner1();     // Initialize Scanner
            flag = 0;
            }

        if (Decode())
            {
            on_beeper (ibeep);               // on Buzzer
            set_led (LED_RED, LED_ON, 5);    // on LED

            HaltScanner1();                  // Stop Scanner
            flag = 1;

            if (iCodeLen > CodeLen)          // Clear old Barcode Data
                for (i=CodeLen; i<iCodeLen; i++)
                    {
                    gotoxy (2+i, 6);
                    putchar (0x20);
                    }

            gotoxy (2, 6);
            puts (CodeBuf);
            iCodeLen = CodeLen;
            }

        OSTimeDly (8);
        }
    }
//-------------------------------------------------------------------------//
